/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLUtil;
import filenet.vw.base.VWLocale;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWEnvironmentData;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public final class VWUserInfo
implements Serializable,
IVWtoXML {
    private static final long serialVersionUID = 7536L;
    public static final int NOTIFICATION_UNDEFINED = 0;
    public static final int NOTIFICATION_STEP_NEW_ASSIGNMENT = 1;
    public static final int NOTIFICATION_STEP_EXPIRED_DEADLINE = 2;
    public static final int NOTIFICATION_STEP_REMINDERS = 4;
    public static final int NOTIFICATION_TRACKER_WORKFLOW_EXCEPTION = 8;
    public static final int NOTIFICATION_TRACKER_EXPIRED_DEADLINE = 16;
    public static final int NOTIFICATION_TRACKER_NEW_ASSIGNMENT = 32;
    public static final int NOTIFICATION_TRACKER_REMINDERS = 64;
    public static final int NOTIFICATION_TRACKER_STEP_EXPIRED_DEADLINE = 128;
    public static final int NOTIFICATION_MILESTONE_TRACKER = 256;
    public static final int NOTIFICATION_MILESTONE_ORIGINATOR = 512;
    private static final int NOTIFICATION_ALL = 1023;
    private static final int MIN_NOTIFICATION_TYPE = 0;
    private static final int MAX_NOTIFICATION_TYPE = 1023;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWUserInfoNotifyUndefined", "Undefined").toString(), new VWString("VW.api.VWUserInfoNotifyStepNewAssignment", "Step New Assignment").toString(), new VWString("VW.api.VWUserInfoNotifyStepExpiredDeadline", "Step Expired Deadline").toString(), new VWString("VW.api.VWUserInfoNotifyStepReminders", "Step Reminders").toString(), new VWString("VW.api.VWUserInfoNotifyTrakcerWFException", "Tracker Workflow Exception").toString(), new VWString("VW.api.VWUserInfoNotifyTrackerWFExpiredDeadline", "Tracker Expired Deadline").toString(), new VWString("VW.api.VWUserInfoNotifyTrackerNewAssignment", "Tracker New Assignment").toString(), new VWString("VW.api.VWUserInfoNotifyTrackerReminders", "Tracker Reminders").toString(), new VWString("VW.api.VWUserInfoNotifyTrackerStepExpiredDeadline", "Tracker Step Expired Deadline").toString(), new VWString("VW.api.VWUserInfoNotifyTrackerMileStone", "Tracker Milestone").toString(), new VWString("VW.api.VWUserInfoNotifyOriginatorMileStone", "Originator Milestone").toString()};
    public static final int SERVER_ID_UNSPECIFIED = -1;
    protected String emailAddress = null;
    protected VWParticipant userPx = null;
    protected int notificationFlags = 0;
    protected int serverIdAssignment = -1;
    protected String systemString = "F_";
    protected Hashtable fieldsHash = null;
    protected VWSession serviceSession = null;
    protected long timeStamp = 0L;
    protected String FEMailAddress = "F_EMailAddress";
    protected String FNotificationFlags = "F_NotificationFlags";
    protected String FDefaultServerId = "F_DefaultServerId";
    protected String FUserProxyId = "F_UserProxyId";
    protected String FPreferredLocale = "F_PreferredLocale";
    protected VWParticipant proxyUserPx = null;
    protected int proxyUserId = -1;
    private Locale preferredLocale = null;
    static final String m_className = "VWUserInfo";
    protected static Logger logger = Logger.getLogger("filenet.vw.api");

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-23 22:00:16 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/1 $";
    }

    private void checkServiceSession(VWSession theServiceSession, String m_method) {
        if (theServiceSession == null) {
            VWException vwe = new VWException(null);
            logger.warning(m_className, m_method, "theServiceSession is NULL");
            logger.throwing(m_className, m_method, vwe);
        }
    }

    private void checkEnvironmentRecord(VWEnvironmentData e, String m_method) {
        if (e == null) {
            VWException vwe = new VWException(null);
            logger.warning(m_className, m_method, "the Environment data is NULL");
            logger.throwing(m_className, m_method, vwe);
        }
    }

    protected VWUserInfo(VWSession theServiceSession) throws VWException {
        this.checkServiceSession(theServiceSession, "ctor1");
        this.serviceSession = theServiceSession;
        this.serviceSession.checkSession();
    }

    protected VWUserInfo(VWSession theServiceSession, String theUserName) throws VWException {
        this.checkServiceSession(theServiceSession, "ctor1");
        this.serviceSession = theServiceSession;
        this.serviceSession.checkSession();
        String domainName = null;
        VWSecurityDomain theDomain = theServiceSession.getDefaultSecurityDomain();
        if (theDomain != null) {
            domainName = theDomain.getDomainName();
        }
        this.initParticipant(theUserName, domainName);
    }

    protected VWUserInfo(VWSession theServiceSession, String theUserName, String theDomainName) throws VWException {
        this.checkServiceSession(theServiceSession, "ctor2");
        this.serviceSession = theServiceSession;
        this.serviceSession.checkSession();
        this.initParticipant(theUserName, theDomainName);
    }

    protected VWUserInfo(VWSession theServiceSession, VWEnvironmentData theEnviro) throws VWException {
        String m_method = "ctor3";
        this.checkServiceSession(theServiceSession, "ctor3");
        this.checkEnvironmentRecord(theEnviro, "ctor3");
        this.serviceSession = theServiceSession;
        this.serviceSession.checkSession();
        this.userPx = theEnviro.getUserPx();
        this.userPx.setCommandSession(this.serviceSession.cmdSession);
        this.timeStamp = theEnviro.getTimeStamp();
        this.fieldsHash = theEnviro.getFieldsTable();
        if (this.fieldsHash != null) {
            if (this.fieldsHash.containsKey(this.FEMailAddress)) {
                this.emailAddress = (String)this.fieldsHash.get(this.FEMailAddress);
            }
            if (this.fieldsHash.containsKey(this.FNotificationFlags)) {
                this.notificationFlags = (Integer)this.fieldsHash.get(this.FNotificationFlags);
            }
            if (this.fieldsHash.containsKey(this.FDefaultServerId)) {
                this.serverIdAssignment = (Integer)this.fieldsHash.get(this.FDefaultServerId);
            }
            if (this.fieldsHash.containsKey(this.FUserProxyId)) {
                this.proxyUserId = (Integer)this.fieldsHash.get(this.FUserProxyId);
            }
            if (this.fieldsHash.containsKey(this.FPreferredLocale)) {
                String locStr = (String)this.fieldsHash.get(this.FPreferredLocale);
                this.preferredLocale = VWLocale.parseLocale(locStr);
            }
        }
    }

    private void initParticipant(String theUserName, String theDomainName) throws VWException {
        if (theUserName == null || theUserName.length() == 0) {
            throw new VWException("vw.api.VWUserInfoBadUserName", "User name cannot be null or empty.");
        }
        String[] theNameList = new String[]{theUserName};
        VWParticipant[] pxList = this.serviceSession.fetchParticipantsPx(theDomainName, theNameList, true);
        if (pxList == null) {
            throw new VWException("vw.api.VWUserInfoSetNameBadUserName", "User name: {0} not found on server.", theUserName);
        }
        if (pxList.length > 1) {
            throw new VWException("vw.api.VWUserInfoSetNameBadUserName", "User name: {0} is not unique.", theUserName);
        }
        this.userPx = pxList[0];
    }

    public String getEMailAddress() {
        return this.emailAddress;
    }

    public void setEMailAddress(String theEMailAddress) throws VWException {
        String sTmpObj = null;
        if (theEMailAddress != null) {
            sTmpObj = theEMailAddress.trim();
        }
        this.emailAddress = sTmpObj;
        this.setFieldValue(this.FEMailAddress, sTmpObj);
    }

    public String getName() {
        if (this.userPx != null) {
            return this.userPx.getParticipantName();
        }
        return null;
    }

    public VWParticipant getNamePx() throws VWException {
        return this.userPx;
    }

    public void setName(String theUserName) throws VWException {
    }

    protected void setName(String theUserName, boolean bRefetch) throws VWException {
        if (theUserName == null || theUserName.length() == 0) {
            throw new VWException("vw.api.VWUserInfoSetNameBadUserName", "User name cannot be null or empty.");
        }
        if (this.userPx == null || bRefetch) {
            this.setVWParticipant(theUserName);
        } else {
            this.userPx.setParticipantName(theUserName);
        }
    }

    protected void setVWParticipant(String theUserName) throws VWException {
        if (theUserName == null || theUserName.length() == 0) {
            throw new VWException("vw.api.VWUserInfoSetNameBadUserName", "User name cannot be null or empty.");
        }
        String[] theNameList = new String[]{theUserName};
        VWParticipant[] pxList = this.serviceSession.fetchParticipantsPx(null, theNameList, true);
        if (pxList == null) {
            throw new VWException("vw.api.VWUserInfoSetNameBadUserName", "User name: {0} not found on server.", theUserName);
        }
        if (pxList.length > 1) {
            throw new VWException("vw.api.VWUserInfoSetNameBadUserName", "User name: {0} is not unique.", theUserName);
        }
        this.userPx = pxList[0];
    }

    public String getProxyUserName() throws VWException {
        if (this.proxyUserPx == null) {
            this.getProxyUserNamePx();
        }
        if (this.proxyUserPx != null) {
            return this.proxyUserPx.getParticipantName();
        }
        return null;
    }

    public VWParticipant getProxyUserNamePx() throws VWException {
        if (this.proxyUserPx == null && this.proxyUserId != -1 && this.proxyUserId != 0 && this.proxyUserId != 9) {
            if (this.serviceSession != null) {
                this.proxyUserPx = this.serviceSession.convertIdToUserNamePx(this.proxyUserId);
            }
            if (this.proxyUserPx != null) {
                this.proxyUserPx.setCommandSession(this.serviceSession.cmdSession);
            }
        }
        return this.proxyUserPx;
    }

    public void setProxyUserName(String theUserName) throws VWException {
        this.setProxyUserNameByDomain(null, theUserName);
    }

    public void setProxyUserNameByDomain(String theDomainName, String theUserName) throws VWException {
        try {
            if (theUserName != null && theUserName.length() > 0) {
                String[] theNameList = new String[]{theUserName};
                VWParticipant[] pxList = this.serviceSession.fetchParticipantsPx(theDomainName, theNameList, true);
                if (pxList == null) {
                    throw new VWException("vw.api.VWUserInfoSetProxyNameBadUserName", "User name: {0} not found on server.", theUserName);
                }
                if (pxList.length > 1) {
                    throw new VWException("vw.api.VWUserInfoSetProxyNameBadUserName", "User name: {0} is not unique.", theUserName);
                }
                this.proxyUserPx = pxList[0];
                if (this.proxyUserPx.getCommandSession() == null) {
                    this.proxyUserPx.setCommandSession(this.serviceSession.cmdSession);
                }
                this.setFieldValue(this.FUserProxyId, new Integer((int)this.proxyUserPx.getUserId()));
            } else {
                this.proxyUserPx = null;
                this.proxyUserId = -1;
                this.setFieldValue(this.FUserProxyId, null);
            }
        }
        catch (VWException ex) {
            throw new VWException("vw.api.VWUserInfoSetProxyNameBadUserName", "User name: {0} not found on server.{1}", theUserName != null ? theUserName : null, ex != null ? ex.getMessage() : null);
        }
    }

    public void setFieldValue(String fieldName, Object fieldValue) throws VWException {
        Object rObj = null;
        int typeNew = VWFieldType.getVWFieldType(fieldValue);
        if (fieldValue != null && (0x1F & typeNew) != typeNew) {
            throw new VWException("vw.api.VWUserInfoInvalidFieldType", "Invalid field type {0}. Field value should be of a basic field type.", new Integer(typeNew));
        }
        if (fieldName != null) {
            if (this.fieldsHash != null && this.fieldsHash.containsKey(fieldName)) {
                rObj = this.fieldsHash.get(fieldName);
                if (rObj != null && fieldValue != null) {
                    int typeOriginal = VWFieldType.getVWFieldType(rObj);
                    if (typeOriginal != typeNew) {
                        throw new VWException("vw.api.VWUserInfoSetFieldValueBadValueType", "Field value {0} should be of type {1}", fieldName, new Integer(typeOriginal));
                    }
                } else if (fieldValue == null) {
                    this.fieldsHash.remove(fieldName);
                    return;
                }
            }
            if (fieldName.equals(this.FEMailAddress)) {
                String sTmpObj = ((String)fieldValue).trim();
                fieldValue = sTmpObj;
            }
            if (this.fieldsHash == null) {
                this.fieldsHash = new Hashtable(1);
            }
            if (fieldValue != null) {
                this.fieldsHash.put(fieldName, fieldValue);
            }
        } else {
            throw new VWException("vw.api.VWUserInfoNullFieldName", "Field name can not be null.");
        }
    }

    public Object getFieldValue(String fieldName) throws VWException {
        Object result = null;
        if (fieldName != null) {
            if (this.fieldsHash != null && this.fieldsHash.containsKey(fieldName)) {
                result = this.fieldsHash.get(fieldName);
            }
        } else {
            throw new VWException("vw.api.VWUserInfoNullFieldName", "Field name can not be null.");
        }
        return result;
    }

    public int getFieldType(String fieldName) throws VWException {
        return VWFieldType.getVWFieldType(this.getFieldValue(fieldName));
    }

    public boolean isFieldArray(String fieldName) throws VWException {
        boolean result = false;
        Object rObj = null;
        rObj = this.getFieldValue(fieldName);
        if (rObj != null && rObj instanceof Object[]) {
            result = true;
        }
        return result;
    }

    public void deleteField(String fieldName) throws VWException {
        if (fieldName != null) {
            this.setFieldValue(fieldName, null);
        }
    }

    public int getNotificationFlags() {
        return this.notificationFlags;
    }

    public void setNotificationFlags(int theFlags) throws VWException {
        if (theFlags < 0 || theFlags > 1023) {
            throw new VWException("vw.api.VWUserInfoInvalidNotificationFlag", "Invalid notification flag {0}.", new Integer(theFlags));
        }
        this.notificationFlags = theFlags;
        this.setFieldValue(this.FNotificationFlags, new Integer(this.notificationFlags));
    }

    public int getServerAssignment() {
        return this.serverIdAssignment;
    }

    public void setServerAssignment(int theServerId) throws VWException {
        if (theServerId == -1 || theServerId < 0) {
            throw new VWException("vw.api.VWUserInfoServerIdUnspecified", "The server ID assignment must be 0 or greater.");
        }
        this.serverIdAssignment = theServerId = 0;
        this.setFieldValue(this.FDefaultServerId, new Integer(this.serverIdAssignment));
    }

    public void save() throws VWException {
        if (this.getName() == null) {
            throw new VWException("vw.api.VWUserInfoBadUserName", "User name can not be null");
        }
        VWEnvironmentData theUserInfo = new VWEnvironmentData();
        theUserInfo.setUserPx(this.userPx);
        String distinguishedName = this.userPx.getParticipantName();
        theUserInfo.setUserName(distinguishedName);
        theUserInfo.setTimeStamp(this.timeStamp);
        theUserInfo.setFieldsTable(this.fieldsHash);
        this.serviceSession.getCmdSession().saveUserInfo(theUserInfo);
    }

    protected void setTimeStamp(long theTimeStamp) {
        this.timeStamp = theTimeStamp;
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        return this.getName();
    }

    public static String getLocalizedString(int theNotificationType) throws VWException {
        if (!VWUserInfo.isValid(theNotificationType)) {
            throw new VWException("vw.api.VWUserInfoBadInteger", "Integer form of the notification type is invalid: {0}", String.valueOf(theNotificationType));
        }
        int offSet = 0;
        if (theNotificationType == 0) {
            offSet = 0;
        } else if (theNotificationType == 1) {
            offSet = 1;
        } else if (theNotificationType == 2) {
            offSet = 2;
        } else if (theNotificationType == 4) {
            offSet = 3;
        } else if (theNotificationType == 8) {
            offSet = 4;
        } else if (theNotificationType == 16) {
            offSet = 5;
        } else if (theNotificationType == 32) {
            offSet = 6;
        } else if (theNotificationType == 64) {
            offSet = 7;
        } else if (theNotificationType == 128) {
            offSet = 8;
        } else if (theNotificationType == 256) {
            offSet = 9;
        } else if (theNotificationType == 512) {
            offSet = 10;
        }
        return LocalizedStrings[offSet];
    }

    public static boolean isValid(int theNotificationType) {
        return theNotificationType == 0 || theNotificationType == 1 || theNotificationType == 2 || theNotificationType == 4 || theNotificationType == 8 || theNotificationType == 16 || theNotificationType == 32 || theNotificationType == 64 || theNotificationType == 128 || theNotificationType == 256 || theNotificationType == 512;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAttributeInfoNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        String INDENT_3 = INDENT_2 + "\t";
        String INDENT_4 = INDENT_3 + "\t";
        String userName = "";
        String proxyUserName = "";
        if (this.userPx != null) {
            if (this.userPx != null) {
                userName = this.userPx.getParticipantName();
            }
            if (this.getProxyUserNamePx() != null) {
                proxyUserName = this.proxyUserPx.getParticipantName();
            }
        }
        theBuffer.append(INDENT_0 + "<" + "UserInfo" + "\n");
        theBuffer.append(INDENT_1 + "UserName" + "=\"" + VWXMLHandler.toXMLString(userName) + "\"\n");
        theBuffer.append(INDENT_1 + "EmailAddress" + "=\"" + VWXMLHandler.toXMLString(this.emailAddress) + "\"\n");
        theBuffer.append(INDENT_1 + "NotificationFlags" + "=\"" + this.notificationFlags + "\"\n");
        theBuffer.append(INDENT_1 + "ServerId" + "=\"" + this.serverIdAssignment + "\"\n");
        theBuffer.append(INDENT_1 + "ProxyUserName" + "=\"" + VWXMLHandler.toXMLString(proxyUserName) + "\"");
        if (this.preferredLocale != null) {
            theBuffer.append(INDENT_1 + "PreferredLocale" + "=\"" + VWXMLHandler.toXMLString(this.preferredLocale.toString()) + "\"");
        }
        theBuffer.append(">\n");
        theBuffer.append(INDENT_1 + "<" + "Fields" + ">\n");
        Enumeration theKeys = this.fieldsHash.keys();
        while (theKeys.hasMoreElements()) {
            String nextKey = (String)theKeys.nextElement();
            if (nextKey.equalsIgnoreCase(this.FEMailAddress) || nextKey.equalsIgnoreCase(this.FNotificationFlags) || nextKey.equalsIgnoreCase(this.FDefaultServerId) || nextKey.equalsIgnoreCase(this.FUserProxyId) || nextKey.equalsIgnoreCase(this.FPreferredLocale)) continue;
            Object nextValue = this.fieldsHash.get(nextKey);
            theBuffer.append(INDENT_2 + "<" + "Field" + "\n");
            theBuffer.append(INDENT_3 + "Name" + "=\"" + VWXMLHandler.toXMLString(nextKey) + "\"\n");
            theBuffer.append(INDENT_3 + "Type" + "=\"" + Integer.toString(this.getFieldType(nextKey)) + "\"\n");
            theBuffer.append(INDENT_3 + "IsArray" + "=\"" + VWXMLHandler.booleanToString(this.isFieldArray(nextKey)) + "\">");
            if (!this.isFieldArray(nextKey)) {
                if (nextValue instanceof Date) {
                    theBuffer.append("\n" + INDENT_4 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)nextValue)) + "</" + "Value" + ">");
                } else {
                    theBuffer.append("\n" + INDENT_4 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(nextValue.toString()) + "</" + "Value" + ">");
                }
            } else {
                int arrayCount = ((Object[])nextValue).length;
                for (int i = 0; i < arrayCount; ++i) {
                    if (((Object[])nextValue)[i] instanceof Date) {
                        theBuffer.append("\n" + INDENT_4 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)((Object[])nextValue)[i])) + "</" + "Value" + ">");
                        continue;
                    }
                    theBuffer.append("\n" + INDENT_4 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(((Object[])nextValue)[i].toString()) + "</" + "Value" + ">");
                }
            }
            theBuffer.append("\n" + INDENT_2 + "</" + "Field" + ">\n");
        }
        theBuffer.append(INDENT_1 + "</" + "Fields" + ">\n");
        theBuffer.append(INDENT_0 + "</" + "UserInfo" + ">\n");
    }

    public void setPreferredLocale(Locale myLocale) throws VWException {
        this.preferredLocale = myLocale;
        this.setFieldValue(this.FPreferredLocale, myLocale != null ? myLocale.toString() : "");
    }

    public Locale getPreferredLocale() throws VWException {
        return this.preferredLocale;
    }
}

